"""

"""

# Created by Jun Wang <jwangfx@connect.ust.hk>
# License: BSD-3-Clause

Electricity = {
    "iTransformer": {
        'n_steps': 96, 
        'n_features': 370, 
        'epochs': 100, 
        'patience': 10, 
        'n_layers': 1, 
        'd_model': 64, 
        'd_ffn': 512, 
        'n_heads': 4, 
        'd_k': 512, 
        'd_v': 128, 
        'dropout': 0.2, 
        'attn_dropout': 0.3, 
        'lr': 0.0010457691294813393,
    },
    "SAITS": {
        'n_steps': 96, 
        'n_features': 370, 
        'epochs': 100, 
        'patience': 10, 
        'n_layers': 2, 
        'd_model': 64, 
        'd_ffn': 512, 
        'n_heads': 8, 
        'd_k': 256, 
        'd_v': 128, 
        'dropout': 0, 
        'attn_dropout': 0.5, 
        'lr': 0.0003804339175723239,
    },
    "FreTS": {
        'n_steps': 96, 
        'n_features': 370, 
        'epochs': 100, 
        'patience': 10, 
        'embed_size': 256, 
        'hidden_size': 128, 
        'channel_independence': False, 
        'lr': 0.0006187379500510781,
    },
    "Koopa": {
        'n_steps': 96, 
        'n_features': 370, 
        'epochs': 100, 
        'patience': 10, 
        'n_seg_steps': 12, 
        'd_dynamic': 64, 
        'd_hidden': 256, 
        'n_hidden_layers': 1, 
        'n_blocks': 3, 
        'lr': 0.002300567240286011,
    },
    "Crossformer": {
        'n_steps': 96, 
        'n_features': 370, 
        'epochs': 100, 
        'patience': 10, 
        'n_layers': 2, 
        'd_model': 512, 
        'd_ffn': 64, 
        'n_heads': 1, 
        'factor': 1, 
        'seg_len': 12, 
        'win_size': 2, 
        'dropout': 0.1, 
        'lr': 0.00045466819252881313,
    },
    "TimesNet": {
        'n_steps': 96, 
        'n_features': 370, 
        'patience': 10, 
        'epochs': 100, 
        'n_layers': 2, 
        'top_k': 4, 
        'd_model': 1024, 
        'd_ffn': 128, 
        'n_kernels': 4, 
        'dropout': 0, 
        'lr': 0.00013095401869683552,
    },
    "PatchTST": {
        'n_steps': 96, 
        'n_features': 370, 
        'epochs': 100, 
        'patience': 10, 
        'patch_len': 16, 
        'stride': 4, 
        'n_layers': 3, 
        'd_model': 64, 
        'd_ffn': 128, 
        'n_heads': 4, 
        'd_k': 128, 
        'd_v': 64, 
        'dropout': 0, 
        'attn_dropout': 0.4, 
        'lr': 0.0003184913248712404,
    },
    "ETSformer": {
        'n_steps': 96, 
        'n_features': 370, 
        'epochs': 100, 
        'patience': 10, 
        'n_e_layers': 3, 
        'n_d_layers': 3, 
        'd_model': 1024, 
        'd_ffn': 128, 
        'n_heads': 8, 
        'top_k': 3, 
        'dropout': 0, 
        'lr': 0.0006563522389223453,
    },
    "MICN": {
        'n_steps': 96, 
        'n_features': 370, 
        'epochs': 100, 
        'patience': 10, 
        'n_layers': 3, 
        'd_model': 128, 
        'conv_kernel': [4, 8], 
        'dropout': 0.5, 
        'lr': 0.000640482394471692,
    },
    "DLinear": {
        'n_steps': 96, 
        'n_features': 370, 
        'epochs': 100, 
        'patience': 10, 
        'moving_avg_window_size': 5, 
        'd_model': 1024, 
        'lr': 0.001026937551416374,
    },
    "SCINet": {
        'n_steps': 96, 
        'n_features': 370, 
        'epochs': 100, 
        'patience': 10, 
        'n_stacks': 2, 
        'n_levels': 1, 
        'n_groups': 1, 
        'n_decoder_layers': 2, 
        'd_hidden': 64, 
        'dropout': 0, 
        'lr': 0.0019603101862858264,
    },
    "NonstationaryTransformer": {
        'n_steps': 96, 
        'n_features': 370, 
        'epochs': 100, 
        'patience': 10, 
        'n_layers': 5, 
        'd_model': 1024, 
        'n_heads': 2, 
        'd_ffn': 256, 
        'n_projector_hidden_layers': 2, 
        'd_projector_hidden': [32, 32], 
        'dropout': 0, 
        'lr': 0.0015842715912180237,
    },
    "FiLM": {
        'n_steps': 96, 
        'n_features': 370, 
        'epochs': 100, 
        'patience': 10, 
        'window_size': [2], 
        'multiscale': [1, 2], 
        'modes1': 64, 
        'dropout': 0.4, 
        'mode_type': 1, 
        'd_model': 512, 
        'lr': 0.0027524405015905526,
    },
    "Pyraformer": {
        'n_steps': 96, 
        'n_features': 370, 
        'epochs': 100, 
        'patience': 10, 
        'n_layers': 3, 
        'd_model': 1024, 
        'd_ffn': 64, 
        'n_heads': 2, 
        'window_size': [4, 4], 
        'inner_size': 3, 
        'dropout': 0.4, 
        'attn_dropout': 0.3, 
        'lr': 0.0003285155359164946,
    },
    "Autoformer": {
        'n_steps': 96, 
        'n_features': 370, 
        'epochs': 100, 
        'patience': 10, 
        'n_layers': 1, 
        'd_model': 1024, 
        'd_ffn': 1024, 
        'n_heads': 4, 
        'factor': 3, 
        'moving_avg_window_size': 5, 
        'dropout': 0.1, 
        'lr': 0.00026832378149235835,
    },
    "CSDI": {
        'n_steps': 96, 
        'n_features': 370, 
        'patience': 10, 
        'epochs': 100, 
        'n_layers': 3, 
        'n_heads': 4, 
        'n_channels': 16, 
        'd_time_embedding': 128, 
        'd_feature_embedding': 8, 
        'd_diffusion_embedding': 32, 
        'lr': 0.0019998503932952497,
    },
    "Informer": {
        'n_steps': 96, 
        'n_features': 370, 
        'epochs': 100, 
        'patience': 10, 
        'n_layers': 3, 
        'd_model': 1024, 
        'd_ffn': 256, 
        'n_heads': 2, 
        'factor': 3, 
        'dropout': 0, 
        'lr': 0.0003908969729950924,
    },
    "USGAN": {
        'n_steps': 96, 
        'n_features': 370, 
        'patience': 10, 
        'epochs': 100, 
        'lr': 0.00031344111157861616, 
        'rnn_hidden_size': 512, 
        'dropout': 0.3,
    },
    "StemGNN": {
        'n_steps': 96, 
        'n_features': 370, 
        'epochs': 100, 
        'patience': 10, 
        'n_layers': 2, 
        'n_stacks': 2, 
        'd_model': 1024, 
        'dropout': 0, 
        'lr': 0.00019510837269346798,
    },
    "GPVAE": {
        'n_steps': 96, 
        'n_features': 370, 
        'latent_size': 132, 
        'patience': 10, 
        'epochs': 100, 
        'lr': 0.002587715335852891, 
        'beta': 0.2, 
        'sigma': 1.005, 
        'length_scale': 7, 
        'encoder_sizes': [256, 256], 
        'decoder_sizes': [512, 512], 
        'window_size': 12,
    },
    "MRNN": {
        'n_steps': 96, 
        'n_features': 370, 
        'patience': 10, 
        'epochs': 100, 
        'rnn_hidden_size': 256, 
        'lr': 0.002913724324373581,
    },
    "BRITS": {
        'n_steps': 96, 
        'n_features': 370, 
        'patience': 10, 
        'epochs': 100, 
        'rnn_hidden_size': 1024, 
        'lr': 0.000648986719843512,
    },
    "GRUD": {
        'n_steps': 96, 
        'n_features': 370, 
        'epochs': 100, 
        'patience': 10, 
        'rnn_hidden_size': 1024, 
        'lr': 0.00034427538906118513,
    },
    "Transformer": {
        'n_steps': 96, 
        'n_features': 370, 
        'epochs': 100, 
        'patience': 10, 
        'n_layers': 3, 
        'd_model': 128, 
        'd_ffn': 1024, 
        'n_heads': 8, 
        'd_k': 512, 
        'd_v': 128, 
        'dropout': 0.4, 
        'attn_dropout': 0.5, 
        'lr': 0.00036045685304465455,
    },
}
